/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010, All Rights Reserved  *
*************************************************************************

************************************************************************
*                                                                      *
*        Standard Software Flash Driver For FTFL           		         *
*                                                                      *
* FILE NAME     :  EEEWrite.c                                          *
* DATE          :  June 11,2010                                        *
*                                                                      *
* AUTHOR        :  FPT Team                                            *
* E-mail        :  b28216@freescale.com                                *
*                                                                      *
************************************************************************/

/************************** CHANGES ***********************************
0.0.1    	06.09.2010    	FPT Team            		Initial Version
0.1.0    	06.11.2010    	FPT Team            		Finalize to 0.1.0 
***********************************************************************/

/* include the header files */
#include "SSD_Types.h"
#include "SSD_FTFL.h"
#include "SSD_FTFL_Internal.h"

/*********************************************************************
*
*  Function Name    : EEEWrite.c
*  Description      : This function is used to write data to EERAM 
*					            when it is used as EEPROM emulator			  
*  Arguments        : PFLASH_SSD_CONFIG,UINT32 ,UINT32 ,UINT32
*  Return Value     : UINT32
*
**********************************************************************/

UINT32 EEEWrite(PFLASH_SSD_CONFIG PSSDConfig, \
									UINT32 destination, \
									UINT32 size, \
									UINT32 source)
{
	UINT32 returnCode;       	/* Return code variable */
	/* set the default return code as FTFL_OK */
  returnCode = FTFL_OK;
	/* Check if EEE is enabled */
	if(REG_READ(PSSDConfig->ftflRegBase + FTFL_FCNFG_OFFSET) & FTFL_FCNFG_EEERDY)
	{
		if(destination < PSSDConfig->EERAMBlockBase || \
		  ((destination + size) > (PSSDConfig->EERAMBlockBase + PSSDConfig->EERAMBlockSize)))
		{
			returnCode = FTFL_ERR_RANGE;
			goto EXIT;
		}
		else
		{
			while(size > 0)
			{	
				while(FALSE == REG_BIT_TEST(PSSDConfig->ftflRegBase + FTFL_FCNFG_OFFSET, FTFL_FCNFG_EEERDY))
				{
					/* wait till EEERDY bit is set */
				}
				WRITE8(destination,READ8(source));
				/* update destination address for next iteration */
				destination += 1;
				/* update size for next iteration */
				size -= 1;
				/* increment the source adress by 1 */
				source += 1;
			}
		}
	}
	else
	{
		returnCode = FTFL_ERR_NOEEE;
		goto EXIT;
	}   	
	
EXIT:
	  /* Enter Debug state if enabled */
    if (TRUE == (PSSDConfig->DebugEnable))
    {
         asm
         (
          debughlt           /* enter Debug state */
         );
    }
	return(returnCode);
}
/* end of file */